/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.auto;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkupContextImporter
implements MarkupModelListener {
    private static final Logger log = Logger.getInstance(MarkupContextImporter.class);
    private int startOffset;
    private int endOffset;
    private boolean offsetRangeVisited;
    private final AtomicBoolean isCodeAnalyzerImportInvoked;
    @NotNull
    private final Project project;
    @NotNull
    Editor editor;
    private Disposable insertionContextDisposable;
    private final Set<String> termList;
    private String lastTerm;
    private final Set<String> foundSet;
    private final List<HighlightInfo.IntentionActionDescriptor> importFixes;

    private MarkupContextImporter(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            MarkupContextImporter.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MarkupContextImporter.$$$reportNull$$$0(1);
        }
        this.offsetRangeVisited = false;
        this.isCodeAnalyzerImportInvoked = new AtomicBoolean(false);
        this.termList = new HashSet<String>();
        this.foundSet = new HashSet<String>();
        this.importFixes = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        this.project = project;
        this.editor = editor;
    }

    public static void tryToImport(@NotNull Editor editor, @NotNull Project project, int startOffset, int endOffset) {
        if (editor == null) {
            MarkupContextImporter.$$$reportNull$$$0(2);
        }
        if (project == null) {
            MarkupContextImporter.$$$reportNull$$$0(3);
        }
        MarkupContextImporter markupContextImporter = new MarkupContextImporter(editor, project);
        markupContextImporter.prepareTokenForImporter(startOffset, endOffset);
    }

    private void importTokens() {
    }

    private void registerMarkupModelListener() {
    }

    private void prepareTokenForImporter(int startOffset, int endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        String insertedText = this.editor.getDocument().getText(new TextRange(startOffset, endOffset));
        String[] terms = insertedText.split("[^A-Za-z0-9_\\$]");
        if (terms.length > 0) {
            for (String term : terms) {
                if (StringUtils.isBlank((CharSequence)term)) continue;
                this.termList.add(term);
            }
            this.lastTerm = terms[terms.length - 1];
            this.insertionContextDisposable = Disposer.newDisposable();
            EditorUtil.disposeWithEditor((Editor)this.editor, (Disposable)this.insertionContextDisposable);
            ((EditorEx)this.editor).getFilteredDocumentMarkupModel().addMarkupModelListener(this.insertionContextDisposable, (MarkupModelListener)this);
        }
    }

    @Nullable
    private HighlightInfo getHighlightInfo(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            MarkupContextImporter.$$$reportNull$$$0(4);
        }
        Object errorTooltip = highlighter.getErrorStripeTooltip();
        return (HighlightInfo)ObjectUtils.tryCast((Object)errorTooltip, HighlightInfo.class);
    }

    private void tryImportUsingCodeAnalyzer(@NotNull PsiFile file) {
        if (file == null) {
            MarkupContextImporter.$$$reportNull$$$0(5);
        }
        if (this.isCodeAnalyzerImportInvoked.get()) {
            return;
        }
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.project);
        ApplicationManager.getApplication().invokeLater(() -> codeAnalyzer.autoImportReferenceAtCursor(this.editor, file));
    }

    private void collectImportFixes(@NotNull PsiFile file, @NotNull RangeHighlighterEx highlighter, @NotNull String highlightedText) {
        if (file == null) {
            MarkupContextImporter.$$$reportNull$$$0(6);
        }
        if (highlighter == null) {
            MarkupContextImporter.$$$reportNull$$$0(7);
        }
        if (highlightedText == null) {
            MarkupContextImporter.$$$reportNull$$$0(8);
        }
        if (highlightedText.length() <= 1) {
            return;
        }
        List availableFixes = ShowIntentionsPass.getAvailableFixes((Editor)this.editor, (PsiFile)file, (int)-1, (int)highlighter.getEndOffset());
        List importActions = availableFixes.stream().filter(f -> {
            String actionText = f.getAction().getText().toLowerCase();
            return actionText.contains("import") && !actionText.contains("remove") && !actionText.contains("optimize") && !actionText.contains("install");
        }).collect(Collectors.toList());
        long potentialCount = importActions.stream().filter(f -> f.getAction().getText().contains(highlightedText)).count();
        if (potentialCount > 1L) {
            log.info(String.format("%d potential import fixes found for %s", potentialCount, highlightedText));
            return;
        }
        if (!importActions.isEmpty()) {
            this.foundSet.add(highlightedText);
            this.termList.remove(highlightedText);
            this.importFixes.add((HighlightInfo.IntentionActionDescriptor)importActions.get(0));
            log.info(String.format("Found import fix for %s", highlightedText));
        }
    }

    public void afterAdded(@NotNull RangeHighlighterEx rangeHighlighterEx) {
        if (rangeHighlighterEx == null) {
            MarkupContextImporter.$$$reportNull$$$0(9);
        }
        if (this.isHighlightPositionPrior(rangeHighlighterEx)) {
            return;
        }
        Document document = rangeHighlighterEx.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        if (this.isHighlightPositionPosterior(rangeHighlighterEx) && this.offsetRangeVisited || this.termList.isEmpty()) {
            this.invokeImportActions(psiFile);
            return;
        }
        try {
            this.offsetRangeVisited = true;
            HighlightInfo highlightInfo = this.getHighlightInfo(rangeHighlighterEx);
            if (highlightInfo == null) {
                return;
            }
            String highlightedText = highlightInfo.getText();
            if (!this.termList.contains(highlightedText)) {
                log.debug(String.format("%s not in term list %s", highlightedText, this.termList.stream().collect(Collectors.joining(","))));
                return;
            }
            log.debug("Try import for " + highlightedText);
            this.tryImportUsingCodeAnalyzer(psiFile);
            this.collectImportFixes(psiFile, rangeHighlighterEx, highlightedText);
            this.termList.remove(highlightedText);
            if (this.shouldFinishListening(highlightedText)) {
                this.invokeImportActions(psiFile);
            }
        }
        catch (Throwable e) {
            Logger.getInstance(this.getClass()).warn("Failed to process highlighter for auto-import", e);
        }
    }

    private boolean hasTermsToAnalyze() {
        return (this.offsetRangeVisited || this.termList.isEmpty()) && CollectionUtils.isNotEmpty(this.importFixes);
    }

    private boolean isHighlightPositionPrior(RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            return true;
        }
        return this.startOffset > highlighter.getAffectedAreaStartOffset();
    }

    private boolean isHighlightPositionPosterior(RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            return true;
        }
        return this.endOffset < highlighter.getAffectedAreaEndOffset();
    }

    private boolean shouldFinishListening(@NotNull String term) {
        if (term == null) {
            MarkupContextImporter.$$$reportNull$$$0(10);
        }
        return term.equals(this.lastTerm) && this.foundSet.contains(term) || this.termList.isEmpty();
    }

    private void invokeImportActions(@NotNull PsiFile file) {
        if (file == null) {
            MarkupContextImporter.$$$reportNull$$$0(11);
        }
        try {
            ArrayList<HighlightInfo.IntentionActionDescriptor> importFixActions = new ArrayList<HighlightInfo.IntentionActionDescriptor>(this.importFixes);
            ApplicationManager.getApplication().invokeLater(() -> importFixActions.forEach(fix -> ShowIntentionActionsHandler.chooseActionAndInvoke((PsiFile)file, (Editor)this.editor, (IntentionAction)fix.getAction(), (String)fix.getAction().getText())));
        }
        catch (Throwable e) {
            log.info(String.format("Invoke auto import action failed", new Object[0]), e);
        }
        finally {
            this.clean();
        }
    }

    private void clean() {
        if (!Disposer.isDisposed((Disposable)this.insertionContextDisposable)) {
            Disposer.dispose((Disposable)this.insertionContextDisposable);
        }
        this.termList.clear();
        this.lastTerm = null;
        this.foundSet.clear();
        this.importFixes.clear();
        this.offsetRangeVisited = false;
        this.isCodeAnalyzerImportInvoked.set(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightedText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeHighlighterEx";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/auto/MarkupContextImporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryToImport";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getHighlightInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "tryImportUsingCodeAnalyzer";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "collectImportFixes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "afterAdded";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldFinishListening";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeImportActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

