/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy;

import com.alibabacloud.intellij.cosy.core.BinaryManager;
import com.alibabacloud.intellij.cosy.editor.CosyEditorActionHandler;
import com.alibabacloud.intellij.cosy.listener.CosyPluginStateListener;
import com.alibabacloud.intellij.cosy.listener.CosyVirtualFileListener;
import com.alibabacloud.intellij.cosy.update.LingmaPluginUpdateChecker;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.concurrent.atomic.AtomicBoolean;

public class LingmaApplication {
    private static final Logger log = Logger.getInstance(LingmaApplication.class);
    private static final String[] EDITOR_ACTIONS = new String[]{"EditorEscape", "ExpandLiveTemplateByTab", "NextTemplateVariable", "EditorBackSpace", "EditorEnter", "EditorUp", "EditorDown", "EditorLeft", "EditorRight", "EditorLineStart", "EditorLineEnd", "EditorDelete", "EditorTab", "EditorChooseLookupItemReplace", "ExpandLiveTemplateByTab", "NextTemplateVariable", "PreviousTemplateVariable", "EditorChooseLookupItem", "Esc", "\u6309 Tab \u5c55\u5f00\u5b9e\u65f6\u6a21\u677f", "\u4e0b\u4e00\u4e2a\u6a21\u677f\u53d8\u91cf\u6216\u5b8c\u6210\u5c31\u5730\u91cd\u6784", "\u9000\u683c", "Enter", "\u4e0a", "\u4e0b", "\u5de6", "\u53f3", "\u4e0b", "\u5c06\u6587\u672c\u5149\u6807\u79fb\u81f3\u884c\u9996", "\u5c06\u6587\u672c\u5149\u6807\u79fb\u81f3\u884c\u5c3e", "\u5220\u9664", "\u6807\u7b7e\u9875", "\u9009\u62e9\u67e5\u8be2\u6761\u76ee\u66ff\u6362", "\u6309 Tab \u5c55\u5f00\u5b9e\u65f6\u6a21\u677f", "\u4e0b\u4e00\u4e2a\u6a21\u677f\u53d8\u91cf\u6216\u5b8c\u6210\u5c31\u5730\u91cd\u6784", "\u4e0a\u4e00\u4e2a\u6a21\u677f\u53d8\u91cf", "\u9009\u62e9\u67e5\u8be2\u6761\u76ee"};
    private static final AtomicBoolean INITED = new AtomicBoolean(false);

    public static synchronized void init() {
        log.info("start to init lingma app");
        if (INITED.getAndSet(true)) {
            return;
        }
        LingmaApplication.doInit();
    }

    public static void doInit() {
        log.info("start to do init lingma app");
        PluginInstaller.addStateListener((PluginStateListener)new CosyPluginStateListener());
        new Thread(() -> {
            log.info("Check binary when app starting...");
            BinaryManager.INSTANCE.checkBinary(false);
        }).start();
        LingmaPluginUpdateChecker.delayCheckUpdate();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new CosyVirtualFileListener());
        LingmaApplication.overrideEditorActions();
    }

    private static void overrideEditorActions() {
        EditorActionManager editorActionManager = EditorActionManager.getInstance();
        for (String action : EDITOR_ACTIONS) {
            AnAction anAction = ActionManager.getInstance().getAction(action);
            if (!(anAction instanceof EditorAction)) {
                log.debug("ignore override action handler:" + action);
                continue;
            }
            EditorAction editorAction = (EditorAction)anAction;
            EditorActionHandler handler = editorAction.getHandler();
            if (handler == null) continue;
            log.debug("override action handler:" + action);
            editorActionManager.setActionHandler(action, (EditorActionHandler)new CosyEditorActionHandler(handler, action));
        }
    }
}

